
 
 
 /****************************************************************
  **    Ex3.Interface Board Glcd with Switch                    ** 
  **										                    **
  **   MCU        : AT89C51ED2                                  **
  **   Compiler   : Keil C51 (V8.05 a)                          **															   *
  **   Baudrate   : 115200 at Clock 18.432 Mhz(6 Clock Mode)	**
  **	                                                        **
  **   Port Control :                                           **
  **                 UART0: P3.0 = Rx0                          **
  **                        P3.1 = Tx0			                **
  **                   P1.0-P1.4 = InPut SW.                    **      
  **                                                            **
  **   Write By : Sittiphol Yooyod(ETT CO.,LTD.)                **
  **                                                            **
  ****************************************************************/ 
						
#include <at89c51xd2.h>
#include <stdio.h>

  unsigned char esc=0x1B,enter=0x0D;

 //------ Check Respond Command -----

  void acho()
   { 
     unsigned char P,K;
     
	 do{
         P = _getkey();        //Read Respond 'O'  
       }while(P != 'O');
  
     do{
         K = _getkey();        //Read Respond 'K'
	   }while(K !='K') ;
   }


  //------------ Function Buile Button  --------------

  //--- Num 0 ----
  void Cir_num0(char fr,char fill,char text)
   {
		TI=1                            ;
        printf("%c00#14=002,02,020,20,%c%c",esc,fr,enter)  ;  //Sent Cmm Plot Rectanc
        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;             //Check Respond CMM


		TI=1                            ;
        printf("%c00#10=011,11,07,%c%c",esc,fill,enter)  ;  //Sent Cmm Plot Circle
        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;             //Check Respond CMM

	    TI=1                            ;
        printf("%c00#30=009,02%c",esc,enter)  ;  //Sent Cmm Set Cursor
        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;             //Check Respond CMM

	    TI=1                            ;
        printf("%c00#31=%c:0%c",esc,text,enter)  ;  //Sent Cmm Plot Write Text
        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;             //Check Respond CMM
   }

    //--- Num 1 ----
    void Cir_num1(char fr, char fill,char text)
     {
	    TI=1                            ;
        printf("%c00#14=043,02,061,20,%c%c",esc,fr,enter)  ;  //Sent Cmm Plot Rectanc
        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;             //Check Respond CMM



     	TI=1                            ;
        printf("%c00#10=052,11,07,%c%c",esc,fill,enter)  ;  //Sent Cmm Plot Circle
        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;             //Check Respond CMM

	    TI=1                            ;
        printf("%c00#30=050,02%c",esc,enter)  ;  //Sent Cmm Set Cursor
        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;             //Check Respond CMM

	    TI=1                            ;
        printf("%c00#31=%c:1%c",esc,text,enter)  ;  //Sent Cmm Plot Write Text
        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;             //Check Respond CMM

	}


      //--- Num 2 ----
  void Cir_num2(char fr,char fill,char text)
   {
	    TI=1                            ;
        printf("%c00#14=022,22,040,40,%c%c",esc,fr,enter)  ;  //Sent Cmm Plot Rectanc
        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;             //Check Respond CMM

     	TI=1                            ;
        printf("%c00#10=031,31,07,%c%c",esc,fill,enter)  ;  //Sent Cmm Plot Circle
        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;             //Check Respond CMM

	    TI=1                            ;
        printf("%c00#30=029,22%c",esc,enter)  ;  //Sent Cmm Set Cursor
        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;             //Check Respond CMM

	    TI=1                            ;
        printf("%c00#31=%c:2%c",esc,text,enter)  ;  //Sent Cmm Plot Write Text
        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;             //Check Respond CMM

	}

      //--- Num 3 ----
  void Cir_num3(char fr,char fill,char text)
   {
		TI=1                            ;
        printf("%c00#14=002,43,020,61,%c%c",esc,fr,enter)  ;  //Sent Cmm Plot Rectanc
        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;             //Check Respond CMM


     	TI=1                            ;
        printf("%c00#10=011,52,07,%c%c",esc,fill,enter)  ;  //Sent Cmm Plot Circle
        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;             //Check Respond CMM

	    TI=1                            ;
        printf("%c00#30=009,43%c",esc,enter)  ;  //Sent Cmm Set Cursor
        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;             //Check Respond CMM

	    TI=1                            ;
        printf("%c00#31=%c:3%c",esc,text,enter)  ;  //Sent Cmm Plot Write Text
        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;             //Check Respond CMM

	}

     //--- Num 4 ----
  void Cir_num4(char fr,char fill,char text)
   {
	    TI=1                            ;
        printf("%c00#14=043,43,061,61,%c%c",esc,fr,enter)  ;  //Sent Cmm Plot Rectanc
        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;             //Check Respond CMM


     	TI=1                            ;
        printf("%c00#10=052,52,07,%c%c",esc,fill,enter)  ;  //Sent Cmm Plot Circle
        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;             //Check Respond CMM

	    TI=1                            ;
        printf("%c00#30=050,43%c",esc,enter)  ;  //Sent Cmm Set Cursor
        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;             //Check Respond CMM

	    TI=1                            ;
        printf("%c00#31=%c:4%c",esc,text,enter)  ;  //Sent Cmm Plot Write Text
        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;             //Check Respond CMM

	}

 //------------------- Display logo sound --------------------

  void logo_sound()
   {
		TI=1                            ;
        printf("%c00#10=095,15,13,0%c",esc,enter)  ;  //Sent Cmm Plot Circle
        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;             //Check Respond CMM
 

	   	TI=1                            ;
        printf("%c00#14=087,01,103,29,2%c",esc,enter)  ;  //Sent Cmm Plot Rectang Del Circle
        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;             //Check Respond CMM
 
		 //-------------------------------------------------------
		TI=1                            ;
        printf("%c00#10=095,15,10,0%c",esc,enter)  ;  //Sent Cmm Plot Circle
        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;             //Check Respond CMM
 

	   	TI=1                            ;
        printf("%c00#14=088,01,102,29,2%c",esc,enter)  ;  //Sent Cmm Plot Rectang Del Circle
        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;             //Check Respond CMM

		//---------------------------------------------------------------
		TI=1                            ;
        printf("%c00#10=095,15,07,0%c",esc,enter)  ;  //Sent Cmm Plot Circle
        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;             //Check Respond CMM
 

	   	TI=1                            ;
        printf("%c00#14=090,01,100,29,2%c",esc,enter)  ;  //Sent Cmm Plot Rectang Del Circle
        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;             //Check Respond CMM
	 
	  //-----------------------------------------------------------------
		TI=1                            ;
        printf("%c00#10=095,15,03,1%c",esc,enter)  ;  //Sent Cmm Plot Circle
        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;             //Check Respond CMM

   }


 //****************** Main Program *********************

 void main(void)
  {
   unsigned char ch;

   CKCON0 = 0x01 ;  // div 6 clk mode  X2=1
   AUXR   = 0x10 ;  //Set XRAM = 1792 Byte
 
	
   //---------initial Uart0 ------------

        BRL     = 0xF6  ;  // Baud Rate 115200
        PCON   |= 0x80  ;  // Set SMOD1=1 :Double BR  
   
        BDRCON  = 0x1E  ;  // Select Internal Baud-Rate,enable,0x1E=Fast BR. //0x1C=No fast BR.	 
        SCON    = 0x50  ;  // Serial Mode1:8bit Uart,enable serial ,Clear Flag Rx/Tx 	   
        ES      = 0     ;  //Disable Serial Uart  Interrupt    
  
	    TI=1                            ;
        printf("%c00#00=%c",esc,enter)  ;   //Sent Cmm  Clear Screen
        while(TI == 0){;}                   //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;   //Check Respond CMM

		TI=1                            ;
        printf("%c00#15=070,00,070,63%c",esc,enter)  ;   //Sent Cmm  Plot Line	 Colum
        while(TI == 0){;}                   //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;   //Check Respond CMM

	

	  //---------------Display Button On GLCD-------------------
 	     
	  	Cir_num0('0','0','1')               ;	  //Plot Button 0

	    Cir_num1('0','0','1')               ;	 //Plot Button 1 
											     
		Cir_num2('0','0','1')               ;	 //Plot Button 2  

		Cir_num3('0','0','1')               ;    //Plot Button 3  
													   
		Cir_num4('0','0','1')               ;	 //Plot Button 4 
													   

  //--------------------- Read key SW.0-4 ----------------------

   P1 = 0XFF ; // P1 Input
 	while(1)
	 { 
	 
	    ch = P1 ;
		ch = ch & 0x1F  ; // No use bit 5-7
	 
	     switch(ch)
		  {
		     case 0x1E :	// Press  Key 0

				        Cir_num0('2','1','0');

					    logo_sound();

					    TI=1                            ;
     				    printf("%c00#30=089,30%c",esc,enter)  ;  //Sent Cmm Set Cursor
     				    while(TI == 0){;}                        //wait Sent CMM Finis Clear Flag TI
      				    TI=0                            ;    
	 				    acho()                          ;       //Check Respond CMM

	    			    TI=1                            ;
       				    printf("%c00#31=1:%c",esc,enter)  ;   //Sent Cmm Plot Write Text
        			    while(TI == 0){;}                       //wait Sent CMM Finis Clear Flag TI
        			    TI=0                            ;    
	    			    acho()                          ;       //Check Respond CMM


						while(ch==0x1E)	 //waite eject SW0.
						 {
					      TI=1                               ;
                          printf("%c00#04=1,2%c",esc,enter)  ; //Sent Cmm Sound
                          while(TI == 0){;}                    //wait Sent CMM Finis Clear Flag TI
                          TI=0                               ;    
	                      acho()                             ; //Check Respond CMM

						  ch= P1                             ; //Read Key SW.
						  ch= ch&0x1F                        ;
						 }

					    TI=1                                           ;
                        printf("%c00#14=003,03,019,19,2%c",esc,enter)  ; //Sent Cmm Plot Rectanc Del Circle
                        while(TI == 0){;}                                //wait Sent CMM Finis Clear Flag TI
                        TI=0                                           ;    
	                    acho()                                         ; //Check Respond CMM

					    Cir_num0('0','0','1')                              ; //Plot Button 0

						TI=1                            ;
                        printf("%c00#14=080,00,110,46,2%c",esc,enter)  ;  //Sent Cmm Plot Rectanc Del Windown Right
                        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
                        TI=0                            ;    
	                    acho()                          ;             //Check Respond CMM

			            break ;


		    case 0x1D :	// Press  Key 1

				        Cir_num1('2','1','0');

					    logo_sound();

					    TI=1                            ;
     				    printf("%c00#30=091,30%c",esc,enter)  ;  //Sent Cmm Set Cursor
     				    while(TI == 0){;}                        //wait Sent CMM Finis Clear Flag TI
      				    TI=0                            ;    
	 				    acho()                          ;       //Check Respond CMM

	    			    TI=1                            ;
       				    printf("%c00#31=1:%c",esc,enter)  ;   //Sent Cmm Plot Write Text
        			    while(TI == 0){;}                       //wait Sent CMM Finis Clear Flag TI
        			    TI=0                            ;    
	    			    acho()                          ;       //Check Respond CMM


						while(ch==0x1D)	 //waite eject SW0.
						 {
					      TI=1                               ;
                          printf("%c00#04=2,2%c",esc,enter)  ; //Sent Cmm Sound
                          while(TI == 0){;}                    //wait Sent CMM Finis Clear Flag TI
                          TI=0                               ;    
	                      acho()                             ; //Check Respond CMM

						  ch= P1                             ; //Read Key SW.
						  ch= ch&0x1F                        ;
						 }

					    TI=1                                           ;
                        printf("%c00#14=044,03,060,19,2%c",esc,enter)  ; //Sent Cmm Plot Rectanc Del Circle
                        while(TI == 0){;}                                //wait Sent CMM Finis Clear Flag TI
                        TI=0                                           ;    
	                    acho()                                         ; //Check Respond CMM

					    Cir_num1('0','0','1')                              ; //Plot Button 1

						TI=1                            ;
                        printf("%c00#14=080,00,110,46,2%c",esc,enter)  ;  //Sent Cmm Plot Rectanc Del Windown Right
                        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
                        TI=0                            ;    
	                    acho()                          ;             //Check Respond CMM

			            break ;



			    case 0x1B :	// Press  Key 2

				        Cir_num2('2','1','0');

					    logo_sound();

					    TI=1                            ;
     				    printf("%c00#30=092,30%c",esc,enter)  ;  //Sent Cmm Set Cursor
     				    while(TI == 0){;}                        //wait Sent CMM Finis Clear Flag TI
      				    TI=0                            ;    
	 				    acho()                          ;       //Check Respond CMM

	    			    TI=1                            ;
       				    printf("%c00#31=1:%c",esc,enter)  ;   //Sent Cmm Plot Write Text
        			    while(TI == 0){;}                       //wait Sent CMM Finis Clear Flag TI
        			    TI=0                            ;    
	    			    acho()                          ;       //Check Respond CMM


						while(ch==0x1B)	 //waite eject SW0.
						 {
					      TI=1                               ;
                          printf("%c00#04=3,2%c",esc,enter)  ; //Sent Cmm Sound
                          while(TI == 0){;}                    //wait Sent CMM Finis Clear Flag TI
                          TI=0                               ;    
	                      acho()                             ; //Check Respond CMM

						  ch= P1                             ; //Read Key SW.
						  ch= ch&0x1F                        ;
						 }

					    TI=1                                           ;
                        printf("%c00#14=023,23,039,39,2%c",esc,enter)  ; //Sent Cmm Plot Rectanc Del Circle
                        while(TI == 0){;}                                //wait Sent CMM Finis Clear Flag TI
                        TI=0                                           ;    
	                    acho()                                         ; //Check Respond CMM

					    Cir_num2('0','0','1')                              ; //Plot Button 2

						TI=1                            ;
                        printf("%c00#14=080,00,110,46,2%c",esc,enter)  ;  //Sent Cmm Plot Rectanc Del Windown Right
                        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
                        TI=0                            ;    
	                    acho()                          ;             //Check Respond CMM

			            break ;



	    case 0x17 :	// Press  Key 3

				        Cir_num3('2','1','0');

					    logo_sound();

					    TI=1                            ;
     				    printf("%c00#30=090,30%c",esc,enter)  ;  //Sent Cmm Set Cursor
     				    while(TI == 0){;}                        //wait Sent CMM Finis Clear Flag TI
      				    TI=0                            ;    
	 				    acho()                          ;       //Check Respond CMM

	    			    TI=1                            ;
       				    printf("%c00#31=1:%c",esc,enter)  ;   //Sent Cmm Plot Write Text
        			    while(TI == 0){;}                       //wait Sent CMM Finis Clear Flag TI
        			    TI=0                            ;    
	    			    acho()                          ;       //Check Respond CMM


						while(ch==0x17)	 //waite eject SW0.
						 {
					      TI=1                               ;
                          printf("%c00#04=4,2%c",esc,enter)  ; //Sent Cmm Sound
                          while(TI == 0){;}                    //wait Sent CMM Finis Clear Flag TI
                          TI=0                               ;    
	                      acho()                             ; //Check Respond CMM

						  ch= P1                             ; //Read Key SW.
						  ch= ch&0x1F                        ;
						 }

					    TI=1                                           ;
                        printf("%c00#14=003,44,019,60,2%c",esc,enter)  ; //Sent Cmm Plot Rectanc Del Circle
                        while(TI == 0){;}                                //wait Sent CMM Finis Clear Flag TI
                        TI=0                                           ;    
	                    acho()                                         ; //Check Respond CMM

					    Cir_num3('0','0','1')                              ; //Plot Button 3

						TI=1                            ;
                        printf("%c00#14=080,00,110,46,2%c",esc,enter)  ;  //Sent Cmm Plot Rectanc Del Windown Right
                        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
                        TI=0                            ;    
	                    acho()                          ;             //Check Respond CMM

			            break ;


			  case 0x0F :	// Press  Key 4

				        Cir_num4('2','1','0');

					    logo_sound();

					    TI=1                            ;
     				    printf("%c00#30=086,30%c",esc,enter)  ;  //Sent Cmm Set Cursor
     				    while(TI == 0){;}                        //wait Sent CMM Finis Clear Flag TI
      				    TI=0                            ;    
	 				    acho()                          ;       //Check Respond CMM

	    			    TI=1                            ;
       				    printf("%c00#31=1:%c",esc,enter)  ;   //Sent Cmm Plot Write Text
        			    while(TI == 0){;}                       //wait Sent CMM Finis Clear Flag TI
        			    TI=0                            ;    
	    			    acho()                          ;       //Check Respond CMM


						while(ch==0x0F)	 //waite eject SW0.
						 {
					      TI=1                               ;
                          printf("%c00#04=5,2%c",esc,enter)  ; //Sent Cmm Sound
                          while(TI == 0){;}                    //wait Sent CMM Finis Clear Flag TI
                          TI=0                               ;    
	                      acho()                             ; //Check Respond CMM

						  ch= P1                             ; //Read Key SW.
						  ch= ch&0x1F                        ;
						 }

					    TI=1                                           ;
                        printf("%c00#14=044,44,060,60,2%c",esc,enter)  ; //Sent Cmm Plot Rectanc Del Circle
                        while(TI == 0){;}                                //wait Sent CMM Finis Clear Flag TI
                        TI=0                                           ;    
	                    acho()                                         ; //Check Respond CMM

					    Cir_num4('0','0','1')                              ; //Plot Button 4

						TI=1                            ;
                        printf("%c00#14=080,00,110,46,2%c",esc,enter)  ;  //Sent Cmm Plot Rectanc Del Windown Right
                        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
                        TI=0                            ;    
	                    acho()                          ;             //Check Respond CMM

			            break ;

	  } //switch
    }	// while

 }	   // main
